(function ($) {
    "use strict";

    // Document Ready
    $(document).ready(function () {

        // initAccordion
        function initAccordion() {
            $(".accordion .accordion_btn").on("click", function () {
                var item = $(this).closest(".accordion_item");
                var body = item.find(".accordion_body");

                // Close others
                $(".accordion_item").not(item).removeClass("active")
                    .find(".accordion_body").slideUp(300);
                $(".accordion_item").not(item).find(".angle_right").removeClass("rotate");

                // Toggle this item
                item.toggleClass("active");
                body.stop(true, true).slideToggle(300);
                item.find(".angle_right").toggleClass("rotate");
            });
        }
        $(document).ready(function () {
            initAccordion();
        });

        // collapse_wrapper
        function FunCollapse() {
            $(".collapse_wrapper").each(function () {
                var wrapper = $(this); // scope to this wrapper only

                wrapper.find(".collapse_btn").on("click", function () {
                    var item = $(this).closest(".custom_collapse");
                    var body = item.find(".collapse_content");

                    // Close others ONLY inside this wrapper
                    wrapper.find(".custom_collapse").not(item).removeClass("active")
                        .find(".collapse_content").slideUp(300);

                    wrapper.find(".custom_collapse").not(item)
                        .find(".angle_right").removeClass("rotate");

                    // Toggle this one
                    item.toggleClass("active");
                    body.stop(true, true).slideToggle(300);
                    item.find(".angle_right").toggleClass("rotate");
                });
            });
        }
        $(document).ready(function () {
            FunCollapse();
        });


        // product_choice
        $(".product_choice").click(function (e) {
            e.stopPropagation();

            // Add selected to clicked item
            $(this).addClass('selected');
            $('.product_choice').not(this).removeClass('selected');

            // Get ID of clicked choice
            var getid = $(this).attr('id');

            // Loop through summary tabs
            $(".product_summary_tab").each(function () {
                var gettabdataval = $(this).attr('data-summary');

                if (getid === gettabdataval) {

                    // SHOW matched tab
                    $(this).addClass('show');

                    // 🔥 Scroll AFTER class is added (ensures correct top position)
                    var target = this;
                    setTimeout(function () {
                        $("html, body").animate(
                            { scrollTop: $(target).offset().top - 30 },
                            600
                        );
                    }, 10);

                } else {
                    // HIDE unmatched tabs
                    $(this).removeClass('show');
                }
            });
        });

        // solution_slider
        new Swiper(".solution_slider", {
            navigation: {
                nextEl: ".solution_slider .swiper-button-next",
                prevEl: ".solution_slider .swiper-button-prev",
            },
            pagination: {
                el: ".swiper-pagination",
                clickable: true,
            },
            speed: 1200,
            autoplay: {
                delay: 5000,
                disableOnInteraction: false,
            },
            breakpoints: {
                0: { slidesPerView: 1, spaceBetween: 20 },
                576: { slidesPerView: 1, spaceBetween: 20 },
                768: { slidesPerView: 1, spaceBetween: 25 },
                992: { slidesPerView: 1, spaceBetween: 40 }
            },
        });

        // Open popup
        $(".solution_slider .swiper-slide img").click(function (e) {
            e.stopPropagation(); // stop document click from firing
            var img = $(this).attr('src');
            $('.modal_img img').attr('src', img);
            $('.image_popup').addClass('active');
        });

        // Close with close button
        $(".close_Btn").click(function (e) {
            e.stopPropagation(); // prevent triggering document click
            $('.image_popup').removeClass('active');
        });

        // Click outside popup → close
        $(document).click(function (e) {
            if (!$(e.target).closest('.modal_img').length) {
                $('.image_popup').removeClass('active');
            }
        });

        // Prevent closing when clicking inside modal
        $('.modal_img').click(function (e) {
            e.stopPropagation();
        });

        // ====================== Index v2 ========================= //
        (function ($) {

            const second = 1000,
                minute = second * 60,
                hour = minute * 60,
                day = hour * 24;

            function startCountdown($el) {

                const targetDate = $el.data("date"); // MM/DD/YYYY
                const countDown = new Date(targetDate).getTime();

                const $days = $el.find(".cd-days");
                const $hours = $el.find(".cd-hours");
                const $minutes = $el.find(".cd-minutes");
                const $seconds = $el.find(".cd-seconds");

                const timer = setInterval(function () {

                    const now = new Date().getTime();
                    const distance = countDown - now;

                    if (distance < 0) {
                        clearInterval(timer);
                        $el.find("ul").html("<li>Time's up!</li>");
                        return;
                    }

                    $days.text(String(Math.floor(distance / day)).padStart(2, "0"));
                    $hours.text(String(Math.floor((distance % day) / hour)).padStart(2, "0"));
                    $minutes.text(String(Math.floor((distance % hour) / minute)).padStart(2, "0"));
                    $seconds.text(String(Math.floor((distance % minute) / second)).padStart(2, "0"));

                }, 1000);
            }

            // Initialize countdowns
            $(".countdown").each(function () {
                startCountdown($(this));
            });

        })(jQuery);


        $(document).on('click', '[data-toggle="tab"]', function (e) {
            e.preventDefault();

            var $this = $(this);
            var target = $this.attr('data-target') || $this.attr('href');

            // Find the tab container
            var $tabWrapper = $this.closest('[role="tablist"], .nav, .nav-tabs');

            // Deactivate all tab buttons in this group
            $tabWrapper.find('[data-toggle="tab"]').removeClass('active').attr('aria-selected', 'false');

            // Activate clicked tab
            $this.addClass('active').attr('aria-selected', 'true');

            // Find related tab-content
            var $tabContent = $(target).closest('.tab-content');

            // Deactivate all panes
            $tabContent.find('.tab-pane').removeClass('show active');

            // Activate target pane
            $(target).addClass('show active');
        });


        // nice-select Initialization
        $('.nice-select').niceSelect();

    });

})(jQuery);
