
// ===================== Circle charts ========================= //
if (document.getElementById('myCircleChart1')) {
    const myCircleChart1 = document.getElementById('myCircleChart1').getContext('2d');

    const dataValues = [20, 25, 30, 35]; // Sums to 100 for easy percentage estimation

    // Colors matching the image (approximated)
    const chartColors = [
        '#0E3355',
        '#1E6F7D',
        '#2F9B9C',
        '#008C8C'
    ];

    new Chart(myCircleChart1, {
        type: 'pie',
        data: {
            // Labels directly from your image
            labels: ['Totaal huur', 'Totaal service', 'Totaal facilitair', 'Totaal techniek'],
            datasets: [{
                label: 'Kosten', // A more relevant label for the dataset
                data: dataValues,
                backgroundColor: chartColors.map(color => color), // Use solid colors
                borderColor: '#ffffff', // White border for separation between slices
                borderWidth: 2 // A slightly thicker border for clear separation
            }]
        },
        options: {
            responsive: true,
            // Keep aspect ratio true for a perfect circle, false to fill container
            maintainAspectRatio: false, // Set to false if you want to control aspect ratio via CSS on canvas

            plugins: {
                legend: {
                    display: false // No external legend as per image
                },
                title: {
                    display: false // No title as per image
                },
                datalabels: {
                    color: '#fff', // White text for labels inside slices
                    formatter: (value, ctx) => {
                        // Display the label text directly from the labels array
                        return ctx.chart.data.labels[ctx.dataIndex];
                    },
                    font: {
                        weight: 'medium',
                        size: 12 // Adjust size if needed
                    },
                    // Add padding to move labels slightly inwards if desired
                    padding: {
                        top: 0,
                        bottom: 0,
                        left: 10,
                        right: 0
                    }
                }
            }
        },
        plugins: [ChartDataLabels] // Ensure plugin is activated
    });
}
if (document.getElementById('myCircleChart2')) {
    const myCircleChart2 = document.getElementById('myCircleChart2').getContext('2d');

    const dataValues = [15, 60, 25, 30]; // Sums to 100 for easy percentage estimation

    // Colors matching the image (approximated)
    const chartColors = [
        '#FF143C',
        '#FFAD0A',
        '#00A0A3',
        '#062C84'
    ];

    new Chart(myCircleChart2, {
        type: 'pie',
        data: {
            // Labels directly from your image
            labels: ['3', '16', '7', '8'],
            datasets: [{
                label: 'Kosten', 
                data: dataValues,
                backgroundColor: chartColors.map(color => color), 
                borderColor: '#ffffff', 
                borderWidth: 2 
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false, 

            plugins: {
                legend: {
                    display: false 
                },
                title: {
                    display: false 
                },
                datalabels: {
                    color: '#fff',
                    formatter: (value, ctx) => {
                        return ctx.chart.data.labels[ctx.dataIndex];
                    },
                    font: {
                        weight: 'medium',
                        size: 16 
                    },
                    padding: {
                        top: 0,
                        bottom: 0,
                        left: 10,
                        right: 0
                    }
                }
            }
        },
        plugins: [ChartDataLabels] // Ensure plugin is activated
    });
}

// =============== Donut Charts =============== //
// Get the canvas context
var myDonut2 = document.getElementById('myDonutChart2').getContext('2d');
var myDonut3 = document.getElementById('myDonutChart3').getContext('2d');
var myDonut4 = document.getElementById('myDonutChart4').getContext('2d');
var myDonut5 = document.getElementById('myDonutChart5').getContext('2d');
var myDonut6 = document.getElementById('myDonutChart6').getContext('2d');

// Create the donut chart
if (document.getElementById('myDonutChart1')) {
    var myDonut1 = document.getElementById('myDonutChart1').getContext('2d');
    new Chart(myDonut1, {
        type: 'doughnut',
        data: {
            labels: [
                "January", "February", "March", "April", "May", "June",
                "July", "August", "September", "October", "November", "December"
            ],
            datasets: [{
                label: 'Monthly Data',
                data: [10, 20, 30, 27, 30, 18, 25, 40, 15, 22, 33, 28],
                backgroundColor: [
                    "#0074D9", // January - blue
                    "#FF4136", // February - red
                    "#2ECC40", // March - green
                    "#FF851B", // April - orange
                    "#B10DC9", // May - purple
                    "#FFDC00", // June - yellow
                    "#39CCCC", // July - cyan
                    "#85144b", // August - maroon
                    "#3D9970", // September - dark green
                    "#7FDBFF", // October - light blue
                    "#F012BE", // November - magenta
                    "#AAAAAA"  // December - grey
                ],
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top', // Legend with months appears at the top
                },
                title: {
                    display: true,
                    text: 'Monthly Data Overview'
                }
            }
        }
    });
}
if (myDonut2) {
    new Chart(myDonut2, {
        type: 'doughnut',
        data: {
            labels: ["Opdracht gekopieerd naar"],
            datasets: [{
                data: ["Opdracht gekopieerd naar"],
                backgroundColor: ["#0074D9"],
                hoverOffset: 10
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                }
            }
        }
    });

}
if (myDonut3) {
    new Chart(myDonut3, {
        type: 'doughnut',
        data: {
            labels: ["Opdracht gekopieerd naar"],
            datasets: [{
                data: ["Opdracht gekopieerd naar"],
                backgroundColor: ["#F012BE"],
                hoverOffset: 10
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                }
            }
        }
    });

}
if (myDonut4) {
    new Chart(myDonut4, {
        type: 'doughnut',
        data: {
            labels: ["unknown"],
            datasets: [{
                data: ["unknown"],
                backgroundColor: ["#3D9970"],
                hoverOffset: 10
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                }
            }
        }
    });
}
if (myDonut5) {
    new Chart(myDonut5, {
        type: 'doughnut',
        data: {
            labels: ["Offerte verzonden", "Opdracht gekopieerd naar", "unknown"],
            datasets: [{
                data: [1, 1, 1], // dummy values (to show legend colors)
                backgroundColor: ["#FFDC00", "#AAAAAA", "#FF851B"]
            }]
        },
        options: {
            responsive: true,
            cutout: '100%', // hides the inner part
            radius: 0, // hides the outer circle (so chart is invisible)
            plugins: {
                legend: {
                    position: 'top', // show labels with colors
                },
                tooltip: {
                    enabled: false
                },
                title: {
                    display: false
                }
            }
        }
    });
}
if (myDonut6) {
    new Chart(myDonut6, {
        type: 'doughnut',
        data: {
            labels: ["Opdracht gekopieerd naar"],
            datasets: [{
                data: ["Opdracht gekopieerd naar"],
                backgroundColor: ["#FF4136"],
                hoverOffset: 10
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                },
                title: {
                    display: false,
                }
            }
        }
    });
}

// =============== Table Charts =============== //
const ordersChart1 = document.getElementById('ordersChart1').getContext('2d');
const ordersChart2 = document.getElementById('ordersChart2').getContext('2d');
const ordersChart3 = document.getElementById('ordersChart3').getContext('2d');
const ordersChart4 = document.getElementById('ordersChart4').getContext('2d');
const ordersChart5 = document.getElementById('ordersChart5').getContext('2d');
const ordersChart6 = document.getElementById('ordersChart6').getContext('2d');
const ordersChart7 = document.getElementById('ordersChart7').getContext('2d');
const ordersChart8 = document.getElementById('ordersChart8').getContext('2d');


// Chart.register(ChartDataLabels);
if (ordersChart1) {
    new Chart(ordersChart1, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
            datasets: [{
                label: 'Total orders for order type: all (Total: 8)',
                data: [1, 1, 0, 1, 1, 3, 0, 0, 1, 0, 0, 0],
                backgroundColor: [
                    "#0074D9", // blue
                    "#FF4136", // red
                    "#2ECC40", // green
                    "#FF851B", // orange
                    "#B10DC9", // purple
                    "#FFDC00", // yellow
                    "#39CCCC", // cyan
                    "#85144b", // maroon
                    "#3D9970", // dark green
                    "#7FDBFF", // light blue
                    "#F012BE", // magenta
                    "#AAAAAA"  // grey
                ],
                barThickness: 25,
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart2) {
    new Chart(ordersChart2, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#FF4136',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart3) {
    new Chart(ordersChart3, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#0074D9',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart4) {
    new Chart(ordersChart4, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#B10DC9',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart5) {
    new Chart(ordersChart5, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#7ab971',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart6) {
    new Chart(ordersChart6, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#034e00',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart7) {
    new Chart(ordersChart7, {
        type: 'bar',
        data: {
            labels: ['Opdracht gekopieerd naar'],
            datasets: [{
                label: 'Order statuses in Month 01 Total(01)',
                data: [1],
                backgroundColor: '#FFDC00',
                borderRadius: 0,
                barThickness: 250,
                hoverOffset: 4
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}
if (ordersChart8) {

    new Chart(ordersChart8, {
        type: 'bar',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov'],
            datasets: [{
                label: 'Total orders for order type: all (Total: 8)',
                data: [1, 1, 0, 1, 1, 3, 0, 0, 1, 0, 0],
                backgroundColor: [
                    "#0074D9", // blue
                    "#FF4136", // red
                    "#2ECC40", // green
                    "#FF851B", // orange
                    "#B10DC9", // purple
                    "#FFDC00", // yellow
                    "#39CCCC", // cyan
                    "#85144b", // maroon
                    "#3D9970", // dark green
                    "#7FDBFF", // light blue
                    "#F012BE", // magenta
                    "#AAAAAA"  // grey
                ],
                barThickness: 25,
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    position: 'top',
                    labels: {
                        boxWidth: 20,
                        color: '#000',
                        font: {
                            size: 13
                        }
                    }
                },
                tooltip: {
                    enabled: true // disable hover tooltips
                },
                datalabels: {
                    color: '#000',
                    font: {
                        weight: 'bold',
                        size: 12
                    },
                    anchor: 'end',
                    align: 'start',
                    formatter: (value) => {
                        // Show label only if value > 0
                        return value > 0 ? value : '';
                    },
                    clip: false,       // ensures labels outside chart area are visible
                    clamp: true,       // keeps label within chart bounds
                }
            },
            scales: {
                x: {
                    grid: {
                        display: true
                    },
                    ticks: {
                        color: '#333',
                        font: {
                            size: 12
                        }
                    }
                },
                y: {
                    beginAtZero: true,
                    max: 3,
                    ticks: {
                        stepSize: 0.5,
                        color: '#333',
                        font: {
                            size: 12
                        }
                    },
                    grid: {
                        color: '#eee'
                    }
                }
            },
            layout: {
                padding: {
                    bottom: 10 // ensures bottom labels (like 0) are fully visible
                }
            }
        },
        plugins: [ChartDataLabels]
    });
}


